% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_plot_trophic.R
\name{e2ep_plot_trophic}
\alias{e2ep_plot_trophic}
\title{Plot showing the annual mean trophic level index, and the omnivory index of each guild during the final year of a model run, optionally with credible intervals.}
\usage{
e2ep_plot_trophic(
  model,
  ci.data = FALSE,
  use.saved = FALSE,
  use.example = FALSE,
  results = NULL
)
}
\arguments{
\item{model}{R-list object defining the baseline model configuration used to generate the data and compiled by the e2ep_read() function.}

\item{ci.data}{Logical. If TRUE plot credible intervals around model results based on Monte Carlo simulation with the e2ep_run_mc() function (default=FALSE).}

\item{use.saved}{Logical. If TRUE use data from a prior user-defined run held as csv files data in the current results folder as set by an e2ep_read() function call (default=FALSE).}

\item{use.example}{NOT YET ENABLED. In future versions - Logical. If TRUE use pre-computed example data from the internal Barents Sea model rather than user-generated data (default=FALSE).}

\item{results}{R-list object of model output generated by the e2ep_run() function. Only needed if ci.data=FALSE, use.saved=FALSE and use.example=FALSE. (Default=NULL).}
}
\value{
Graphical display in a new graphics window.
}
\description{
Generate a two-panel plot showing: (upper panel) the mean trophic level of each guild in the ecology model, and (lower panel) the omnivory index of each guild. The data are 
generated by the NetIndices package from a flow matrix of nutrient fluxes through, into and out of the ecosystem during the final year of a run. The data are generated
automatically as part of the output from every call of the e2ep_run() function. The default is to plot data from a single model run but if available, 
credible intervals of model output from a Monte Carlo analysis can be plotted instead.
}
\details{
If credible intervals are plotted these are displayed as box-and-whiskers. The box spans 50% of the likelihood distribution of values and the whiskers 99%. The median is shown 
by a black tick mark and the maximum likelihhod model by a red tick mark.

Arguments determine the source of model data to be plotted. These can be outputs from a single model run with data held in memory as a list object or in a saved csv file, or from 
a Monte Carlo simulation (using the function e2ep_run_mc()) to estimate credible intervals of model outputs. Generation of credible interval data is a long computing task, so 
example data for the Barents Sea model provided with the package are available as illustration.
}
\examples{
# Load the 2011-2019 version of the Barents Sea model supplied with the package, 
# run, and generate a plot:
   model <- e2ep_read("Barents_Sea", "2011-2019")
   results <- e2ep_run(model,nyears=1,csv.output=FALSE)
   e2ep_plot_trophic(model, results=results)

# Direct the graphics output to a pdf file ... 
# or jpeg("plot.jpg"), png("plot.png")
   pdf(file.path(tempdir(), "plot.pdf"),width=6,height=8)
   e2ep_plot_trophic(model, results=results)
   dev.off()

# Alternatively, plot the same data from a csv file saved in a temporary 
# folder by the e2ep_run() function:
   model <- e2ep_read("Barents_Sea", "2011-2019")
   results <- e2ep_run(model, nyears=1, csv.output=TRUE)
   e2ep_plot_trophic(model, use.saved=TRUE)

# For the same model, plot the example data with credible intervals:
# This example requires the StrathE2EPolarexamples supplementary data package.
if(require(StrathE2EPolarexamples)){
   e2ep_plot_trophic(model, ci.data=TRUE, use.example=TRUE)
}

}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_plot_migration}}, \code{\link{e2ep_plot_catch}}, \code{\link{e2ep_plot_eco}}, \code{\link{e2ep_plot_biomass}}
}
