% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_plot_ts.R
\name{e2ep_plot_ts}
\alias{e2ep_plot_ts}
\title{Plot ecology model state variables or fishery catches for the full duration of a model run.}
\usage{
e2ep_plot_ts(model, results, selection = "ECO")
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2ep_read() function.}

\item{results}{R-list object containing model results generated by the e2ep_run() function.}

\item{selection}{Text string from a list identifying whether ecology state variable or fishery catches are to be plotted. Select from: "ECO", "CATCH", default = "ECO". Remember to include the phrase within "" quotes.}
}
\value{
Graphical display in a new graphics window.
}
\description{
Multi-panel time-series plots of either ecology state variable data, or fishery landings and discards, for the full duration of a model run generated by the e2ep_run() function.
}
\details{
The function plots a multi-panel page of time series plots of either a) daily ecology state variable values aggregated over the inshore and offshore zones of the domain and over sediment classes, 
or b) annual landings and discards by zone for each model guild, for the full duration of a model run.
Currently the masses of macrophytes, corpses and discards are not included in the state varibale plots due to space constraints.

Be warned that if the run is more than about 10 years then the plot becomes extremely compressed and messy. It is not intended to
be of publication quality. The intention is to provide a quick-look diagnostic of trends in the state variables. This is useful to assess
whether the model is close to stationary state or not.

Units of the plotted state varaiables mMN i.e. mass in the model domain without any scaling to zone-area or layer thickness. Similarly, units of catches are mMN/y from the whole model domain without any scaling to zone-area. The assumed area of the whole model domain is 1 m2.

Selection of either ecology state variable or catches to plot is by a function argument.

A separate set of functions is provided for plotting more detailed visualizations of just the final year from a model run, e.g. e2ep_plot_eco(), e2ep_plot_catch().
}
\examples{
# Load the 2011-2019 version of the Barents Sea model supplied with the package:
    model <- e2ep_read("Barents_Sea", "2011-2019")
#Run the model and generate the results object, with csv output suppressed
    results <- e2ep_run(model,nyears=2, csv.output=FALSE)
# Plot the time series of ecology state variable outputs
    e2ep_plot_ts(model, results, selection="ECO")
# Time series plot of catches in a new window leaving the existing window open
    dev.new()
    e2ep_plot_ts(model, results, selection="CATCH")

#Direct the graphics output to a file (Windows OS)... 
# or jpeg("plot.jpg"), png("plot.png")
    pdf(file.path(tempdir(), "plot.pdf"),width=8,height=6)
    e2ep_plot_ts(model, results, selection="ECO")
    dev.off()

\donttest{
# Demonstrate transient behaviour in the time-series outputs (run for 10 years).
# Read the Barents Sea/2011-2019 model and set the identifier for output files to "baseline",
# run the model and plot the full length output
    model <- e2ep_read("Barents_Sea", "2011-2019",model.ident="baseline")
    results <- e2ep_run(model,nyears=10, csv.output=FALSE)
    e2ep_plot_ts(model, results, selection="ECO")
    dev.new()
    e2ep_plot_ts(model, results, selection="CATCH")
# Create a new scenario version of the Barents Sea/2011-2019 model by increasing the activity
# rate of gear 1 (pelagic trawls and seines) by a factor of 3
    scenario_model <- model
    scenario_model$data$fleet.model$gear_mult[1] <- 3
    scenario_model$setup$model.ident <- "gear1x3"    # Set a new identifier for the outputs
    scenario_results <- e2ep_run(scenario_model,nyears=10, csv.output=FALSE)
    dev.new() 
    e2ep_plot_ts(scenario_model, scenario_results, selection="ECO")
    dev.new()
    e2ep_plot_ts(scenario_model, scenario_results, selection="CATCH")
}
}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_plot_eco}}, \code{\link{e2ep_plot_catch}}
}
