% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_get_parmdoc.R
\name{e2ep_get_parmdoc}
\alias{e2ep_get_parmdoc}
\title{Get documentation on the parameters in the model.}
\usage{
e2ep_get_parmdoc(selection = "SENS", id = 9)
}
\arguments{
\item{selection}{Text string from a list identifying the level of parameters to be listed. Select from: "MC", "SENS", Remember to include the phrase within "" quotes (default = "SENS")}

\item{id}{Integer value denoting the class of parameters details to be downloaded. Choose from: 0 = fitted ecology, 1 = fixed ecology, 2 = fishing fleet, 3 = harvest ratios, 4 = environmental drivers, 5 = physical configuration, 9 = all (default = 9). Options 2-5 not available with "MC".}
}
\value{
dataframe of parameter documentation.
}
\description{
Provides access to documentation on the parameters in the model in the form of a dataframe.
}
\details{
There are two levels of parameters for the model - the raw input parameters as extracted from the parameter csv files, and an expanded set of parameters, derive from the raw values, which are injected into the the model run.

The Monte Carlo simulation function in the package acts on the raw ecology model parameters, jigging each by a a random increment, to generate test parameter sets. The ecology model parameters are divided into fixed and fitted subsets based on whether they are available for optimization or not.

The Global Sensitivity analysis function in the package acts on the expanded parameter set. As well as fixed and fitted ecology parameters, the expanded set includes the physical setup parameters, fishing fleet parameters, harvest ratios, and environmental drivers.

This function downloads documentation on the full range of parameters in the form of a dataframe which can be used to form labels in user-generated code. The parameters are identified by a numeric value linked to 6 different classes of parameter.

Note that the function does not supply the numeric values of parameters for any given model setup. These are available in the model definition object generated by the function e2e_read().
}
\examples{
# Details of all the fitted ecology parameters used in the Monte Carlo function:
    parm_list <- e2ep_get_parmdoc("MC",0)        
# Details of all parameters in the sensitivity analysis function:
    parm_list <- e2ep_get_parmdoc("SENS",9)
# ... or simply:
    parm_list <- e2ep_get_parmdoc()

}
\seealso{
\code{\link{e2ep_read}}
}
