% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_get_senscrit.R
\name{e2ep_get_senscrit}
\alias{e2ep_get_senscrit}
\title{Get documentation on the model outputs available as the basis for sensitivity analysis.}
\usage{
e2ep_get_senscrit(id = "A")
}
\arguments{
\item{id}{Single character (in "") or integer value denoting the class or id of output criterion to be downloaded. Choose single value from 0:274 = unique criterion, A = All (default), L = Likelihood, M = Annual average mass, F = Annual integrated fluxes.}
}
\value{
screen display and dataframe of parameter documentation.
}
\description{
Provides access to documentation on outputs from the model which may be deployed as the basis for a sensitivity analysis using e2ep_run_sens().
}
\details{
The function e2ep_run_sens() performs a Morris Method sensitivity analysis on the model. The default criterion for assessing the model sensitivity
is the likelihood of the observed target data set on the state of the ecosystem given each set of model drivers and parameters. 
However, a function argument allows other criteria to be chosen as the basis for the analysis from the list of annually averaged or integrated variables saved in the output objects:
\itemize{
  \item results$final.year.output$mass_results_wholedomain (whole-domain annual averages of stage variables over the final year of a model run), and 
  \item results$final.year.output$annual_flux_results_wholedomain (whole-domian annual integrals of fluxes between state variables over the final year of a model run).
}
The criterion is chosen by setting a value for the argument outID. The default outID=0 selects the likelihood of the observed target data. Other values in the range 1 to 247 select annualy averaged mass or 
annually integrated flux outputs. The function presented here provides a list of all the available outputs that may be used and their outID values.
}
\examples{
    crit_list <- e2ep_get_senscrit("M")   # Get a list of annual average mass criteria      
    crit_list <- e2ep_get_senscrit("F")   # Get a list of annual integrated flux criteria
    crit_list <- e2ep_get_senscrit(24)    # Get details of criteria matching id=24
    crit_list <- e2ep_get_senscrit()      # Get a list of all available criteria

}
\seealso{
\code{\link{e2ep_run_sens}}
}
