#
# CredInt_make_daily_flux_results.R
#
#' Save current set of fitted parameters to file
#'
#' @param model model object
#' @param lastyearstore inshore annual flux data
#' @param csv.output (TRUE or FALSE, default=TRUE) Set to FALSE to disable writing of CSV output files - useful for testing
#'
#' @importFrom graphics abline
#'
#' @noRd
#
# ------------------------------------------------------------------------------

CredInt_make_daily_flux_results <- function(model, lastyearstore,csv.output) {

	pkg.env$csv.output <- csv.output	# controls writing of CSV files

	resultsdir <- elt(model, "setup", "resultsdir")
	identifier <- elt(model, "setup", "model.ident")

	credpath <- makepath(resultsdir, CREDINT_DIR)




#THIS VERSION PROCESSES THE FLUX DATA SAVED IN THE CUMULATIVE DAILY OUTPUT STORE
#
#THE FLUX DATA ARE CUMULATIVE SO FIRST THING TO DO IS MAKE A NEW DATAFRAME CONTAINING
#THE DAILY INCREMENTS.



lastyearstore$dummy<-1


# names(lastyearstore)
#   [1] "time"                       "detritus_so"                "detritus_d"                
#   [4] "x_detritus_s1"              "x_detritus_s2"              "x_detritus_s3"             
#   [7] "x_detritus_d1"              "x_detritus_d2"              "x_detritus_d3"             
#  [10] "xR_detritus_s1"             "xR_detritus_s2"             "xR_detritus_s3"            
#  [13] "xR_detritus_d1"             "xR_detritus_d2"             "xR_detritus_d3"            
#  [16] "discard_o"                  "corpse_s1"                  "corpse_s2"                 
#  [19] "corpse_s3"                  "corpse_d1"                  "corpse_d2"                 
#  [22] "corpse_d3"                  "ammonia_so"                 "ammonia_d"                 
#  [25] "x_ammonia_s1"               "x_ammonia_s2"               "x_ammonia_s3"              
#  [28] "x_ammonia_d1"               "x_ammonia_d2"               "x_ammonia_d3"              
#  [31] "nitrate_so"                 "nitrate_d"                  "x_nitrate_s1"              
#  [34] "x_nitrate_s2"               "x_nitrate_s3"               "x_nitrate_d1"              
#  [37] "x_nitrate_d2"               "x_nitrate_d3"               "phyt_so"                   
#  [40] "phyt_d"                     "omni_o"                     "carn_o"                    
#  [43] "benthslar_o"                "benths_o"                   "benthclar_o"               
#  [46] "benthc_o"                   "fishp_o"                    "fishplar_o"                
#  [49] "fishd_o"                    "fishdlar_o"                 "fishm_o"                   
#  [52] "bird_o"                     "detritus_si"                "ammonia_si"                
#  [55] "nitrate_si"                 "phyt_si"                    "benthslar_i"               
#  [58] "benthclar_i"                "benths_i"                   "benthc_i"                  
#  [61] "discard_i"                  "omni_i"                     "carn_i"                    
#  [64] "fishplar_i"                 "fishdlar_i"                 "fishp_i"                   
#  [67] "fishm_i"                    "fishd_i"                    "bird_i"                    
#  [70] "seal_o"                     "seal_i"                     "ceta_o"                    
#  [73] "ceta_i"                     "corpse_s0"                  "corpse_d0"                 
#  [76] "kelpC"                      "kelpN"                      "kelpdebris"                
#  [79] "snow_ammonia_o"             "snow_nitrate_o"             "ice_ammonia_o"             
#  [82] "ice_nitrate_o"              "ice_detritus_o"             "ice_algae_o"               
#  [85] "snow_ammonia_i"             "snow_nitrate_i"             "ice_ammonia_i"             
#  [88] "ice_nitrate_i"              "ice_detritus_i"             "ice_algae_i"               
#  [91] "bear_o"                     "bear_i"                     "htlcorp_o"                 
#  [94] "htlcorp_i"                  "wintering_bird_o"           "wintering_bird_i"          
#  [97] "wintering_seal_o"           "wintering_seal_i"           "wintering_ceta_o"          
# [100] "wintering_ceta_i"           "wintering_bear_o"           "wintering_bear_i"          
# [103] "netpprod_o"                 "netpprod_i"                 "PNP_o"                     
# [106] "PNP_i"                      "phytgrossprod_o"            "phytgrossprod_i"           
# [109] "kelpCprod_i"                "kelpCexud_i"                "kelpNprod_i"               
# [112] "omnigrossprod_o"            "omnigrossprod_i"            "carngrossprod_o"           
# [115] "carngrossprod_i"            "pfishlargrossprod_o"        "pfishlargrossprod_i"       
# [118] "dfishlargrossprod_o"        "dfishlargrossprod_i"        "pfishgrossprod_o"          
# [121] "pfishgrossprod_i"           "mfishgrossprod_o"           "mfishgrossprod_i"          
# [124] "dfishgrossprod_o"           "dfishgrossprod_i"           "benthslargrossprod_o"      
# [127] "benthslargrossprod_i"       "benthclargrossprod_o"       "benthclargrossprod_i"      
# [130] "benthsgrossprod_o"          "benthsgrossprod_i"          "benthcgrossprod_o"         
# [133] "benthcgrossprod_i"          "birdgrossprod_o"            "birdgrossprod_i"           
# [136] "sealgrossprod_o"            "sealgrossprod_i"            "cetagrossprod_o"           
# [139] "cetagrossprod_i"            "beargrossprod_o"            "beargrossprod_i"           
# [142] "wcdenitrif_o"               "wcdenitrif_i"               "seddenitrif_o"             
# [145] "seddenitrif_i"              "fluxsedamm_wcamm"           "fluxwcdet_wcamm"           
# [148] "fluxomni_wcamm"             "fluxcarn_wcamm"             "fluxpfishlar_wcamm"        
# [151] "fluxdfishlar_wcamm"         "fluxpfish_wcamm"            "fluxmfish_wcamm"           
# [154] "fluxdfish_wcamm"            "fluxbenthslar_wcamm"        "fluxbenthclar_wcamm"       
# [157] "fluxbenths_wcamm"           "fluxbenthc_wcamm"           "fluxbird_wcamm"            
# [160] "fluxseal_wcamm"             "fluxceta_wcamm"             "fluxbear_wcamm"            
# [163] "fluxxdet_sedamm"            "fluxxRdet_sedamm"           "fluxwcamm_wcnit"           
# [166] "fluxsednit_wcnit"           "fluxsedamm_sednit"          "fluxxdet_wcdet"            
# [169] "fluxkelpdebris_wcdet"       "fluxcorp_wcdet"             "fluxphyt_wcdet"            
# [172] "fluxomni_wcdet"             "fluxcarn_wcdet"             "fluxpfishlar_wcdet"        
# [175] "fluxdfishlar_wcdet"         "fluxpfish_wcdet"            "fluxmfish_wcdet"           
# [178] "fluxdfish_wcdet"            "fluxbenthslar_wcdet"        "fluxbenthclar_wcdet"       
# [181] "fluxbenths_wcdet"           "fluxbenthc_wcdet"           "fluxbird_wcdet"            
# [184] "fluxseal_wcdet"             "fluxceta_wcdet"             "fluxbear_wcdet"            
# [187] "fluxwcdet_xdet"             "fluxcorp_xdet"              "fluxbenths_xdet"           
# [190] "fluxbenthc_xdet"            "fluxxdet_xRdet"             "fluxkelpdebris_xRdet"      
# [193] "fluxcorp_xRdet"             "fluxkelp_kelpdebris"        "fluxdisc_corp"             
# [196] "fluxpfish_corp"             "fluxmfish_corp"             "fluxdfish_corp"            
# [199] "fluxbenths_corp"            "fluxbenthc_corp"            "fluxbird_corp"             
# [202] "fluxseal_corp"              "fluxceta_corp"              "fluxbear_corp"             
# [205] "fluxwcamm_kelp"             "fluxwcnit_kelp"             "fluxwcamm_phyt_o"          
# [208] "fluxwcamm_phyt_i"           "fluxwcnit_phyt_o"           "fluxwcnit_phyt_i"          
# [211] "fluxwcdet_omni"             "fluxphyt_omni"              "fluxbenthslar_omni"        
# [214] "fluxbenthclar_omni"         "fluxomni_carn"              "fluxpfishlar_carn"         
# [217] "fluxdfishlar_carn"          "fluxbenthslar_carn"         "fluxbenthclar_carn"        
# [220] "fluxomni_pfishlar"          "fluxbenthslar_pfishlar"     "fluxbenthclar_pfishlar"    
# [223] "fluxomni_dfishlar"          "fluxbenthslar_dfishlar"     "fluxbenthclar_dfishlar"    
# [226] "fluxomni_pfish"             "fluxcarn_pfish"             "fluxpfishlar_pfish"        
# [229] "fluxdfishlar_pfish"         "fluxbenthslar_pfish"        "fluxbenthclar_pfish"       
# [232] "fluxomni_mfish"             "fluxcarn_mfish"             "fluxpfishlar_mfish"        
# [235] "fluxdfishlar_mfish"         "fluxbenthslar_mfish"        "fluxbenthclar_mfish"       
# [238] "fluxcorp_dfish"             "fluxdisc_dfish"             "fluxcarn_dfish"            
# [241] "fluxpfishlar_dfish"         "fluxdfishlar_dfish"         "fluxpfish_dfish"           
# [244] "fluxmfish_dfish"            "fluxdfish_dfish"            "fluxbenths_dfish"          
# [247] "fluxbenthc_dfish"           "fluxwcdet_benthslar"        "fluxphyt_benthslar"        
# [250] "fluxwcdet_benthclar"        "fluxphyt_benthclar"         "fluxwcdet_benths"          
# [253] "fluxxdet_benths"            "fluxxRdet_benths"           "fluxphyt_benths"           
# [256] "fluxkelp_benthc"            "fluxkelpdebris_benthc"      "fluxcorp_benthc"           
# [259] "fluxbenths_benthc"          "fluxcorp_bird"              "fluxdisc_bird"             
# [262] "fluxcarn_bird"              "fluxpfish_bird"             "fluxmfish_bird"            
# [265] "fluxdfish_bird"             "fluxbenths_bird"            "fluxbenthc_bird"           
# [268] "fluxcorp_seal"              "fluxdisc_seal"              "fluxcarn_seal"             
# [271] "fluxpfish_seal"             "fluxmfish_seal"             "fluxdfish_seal"            
# [274] "fluxbenths_seal"            "fluxbenthc_seal"            "fluxbird_seal"             
# [277] "fluxdisc_ceta"              "fluxomni_ceta"              "fluxcarn_ceta"             
# [280] "fluxpfish_ceta"             "fluxmfish_ceta"             "fluxdfish_ceta"            
# [283] "fluxbenths_ceta"            "fluxbenthc_ceta"            "fluxbird_ceta"             
# [286] "fluxseal_ceta"              "fluxcorp_bear"              "fluxbird_bear"             
# [289] "fluxseal_bear"              "fluxceta_bear"              "Bs_spawn"                  
# [292] "Bs_recruit"                 "Bc_spawn"                   "Bc_recruit"                
# [295] "Pfish_spawn"                "Pfish_recruit"              "Dfish_spawn"               
# [298] "Dfish_recruit"              "fluxwcnit_Ngas"             "fluxsednit_Ngas"           
# [301] "fluxkelpdebris_beachexport" "fluxAMMoutflow_o"           "fluxNIToutflow_o"          
# [304] "fluxAMMoutflow_i"           "fluxNIToutflow_i"           "fluxPHYToutflow_o"         
# [307] "fluxDEToutflow_o"           "fluxPHYToutflow_i"          "fluxDEToutflow_i"          
# [310] "mfish_emigration"           "fluxsedboundary_o"          "fluxsedboundary_i"         
# [313] "fluxAMMinflow_o"            "fluxNITinflow_o"            "fluxAMMinflow_i"           
# [316] "fluxNITinflow_i"            "fluxPHYTinflow_o"           "fluxDETinflow_o"           
# [319] "fluxPHYTinflow_i"           "fluxDETinflow_i"            "mfish_imigration"          
# [322] "atmosAMMinput_o"            "atmosNITinput_o"            "atmosAMMinput_i"           
# [325] "atmosNITinput_i"            "rivAMMinflow"               "rivNITinflow"              
# [328] "rivPARTinflow"              "DINflux_i_o"                "DINflux_o_i"               
# [331] "PARTflux_i_o"               "PARTflux_o_i"               "activemigpelfish_i_o"      
# [334] "activemigmigfish_i_o"       "activemigdemfish_i_o"       "activemigbird_i_o"         
# [337] "activemigseal_i_o"          "activemigceta_i_o"          "activemigbear_i_o"         
# [340] "activemigpelfish_o_i"       "activemigmigfish_o_i"       "activemigdemfish_o_i"      
# [343] "activemigbird_o_i"          "activemigseal_o_i"          "activemigceta_o_i"         
# [346] "activemigbear_o_i"          "vertnitflux"                "horiznitflux"              
# [349] "landp_o"                    "landd_quota_o"              "landd_nonquota_o"          
# [352] "landm_o"                    "landsb_o"                   "landcb_o"                  
# [355] "landcz_o"                   "landbd_o"                   "landsl_o"                  
# [358] "landct_o"                   "discpel_o"                  "discdem_quota_o"           
# [361] "discdem_nonquota_o"         "discmig_o"                  "discsb_o"                  
# [364] "disccb_o"                   "disccz_o"                   "discbd_o"                  
# [367] "discsl_o"                   "discct_o"                   "landp_i"                   
# [370] "landd_quota_i"              "landd_nonquota_i"           "landm_i"                   
# [373] "landsb_i"                   "landcb_i"                   "landcz_i"                  
# [376] "landbd_i"                   "landsl_i"                   "landct_i"                  
# [379] "landkp_i"                   "discpel_i"                  "discdem_quota_i"           
# [382] "discdem_nonquota_i"         "discmig_i"                  "discsb_i"                  
# [385] "disccb_i"                   "disccz_i"                   "discbd_i"                  
# [388] "discsl_i"                   "discct_i"                   "disckp_i"                  
# [391] "offalpel_o"                 "offaldem_quota_o"           "offaldem_nonquota_o"       
# [394] "offalmig_o"                 "offalsb_o"                  "offalcb_o"                 
# [397] "offalcz_o"                  "offalbd_o"                  "offalsl_o"                 
# [400] "offalct_o"                  "offalpel_i"                 "offaldem_quota_i"          
# [403] "offaldem_nonquota_i"        "offalmig_i"                 "offalsb_i"                 
# [406] "offalcb_i"                  "offalcz_i"                  "offalbd_i"                 
# [409] "offalsl_i"                  "offalct_i"                  "offalkp_i"                 
# [412] "omninetprod_o"              "omninetprod_i"              "carnnetprod_o"             
# [415] "carnnetprod_i"              "pfishlarnetprod_o"          "pfishlarnetprod_i"         
# [418] "dfishlarnetprod_o"          "dfishlarnetprod_i"          "pfishnetprod_o"            
# [421] "pfishnetprod_i"             "mfishnetprod_o"             "mfishnetprod_i"            
# [424] "dfishnetprod_o"             "dfishnetprod_i"             "benthslarnetprod_o"        
# [427] "benthslarnetprod_i"         "benthclarnetprod_o"         "benthclarnetprod_i"        
# [430] "benthsnetprod_o"            "benthsnetprod_i"            "benthcnetprod_o"           
# [433] "benthcnetprod_i"            "birdnetprod_o"              "birdnetprod_i"             
# [436] "sealnetprod_o"              "sealnetprod_i"              "cetanetprod_o"             
# [439] "cetanetprod_i"              "bearnetprod_o"              "bearnetprod_i"             
# [442] "neticealgprod_o"            "neticealgprod_i"            "icealggrossprod_o"         
# [445] "icealggrossprod_i"          "fluxwcamm_icealg_o"         "fluxwcamm_icealg_i"        
# [448] "fluxwcnit_icealg_o"         "fluxwcnit_icealg_i"         "icesnowdenitrif_o"         
# [451] "icesnowdenitrif_i"          "atmosAMMinputsnow_o"        "atmosNITinputsnow_o"       
# [454] "atmosAMMinputsnow_i"        "atmosNITinputsnow_i"        "atmosAMMinputwater_o"      
# [457] "atmosNITinputwater_o"       "atmosAMMinputwater_i"       "atmosNITinputwater_i"      
# [460] "fluxsnowamm_wcamm"          "fluxsnowamm_snownit"        "fluxiceamm_wcamm"          
# [463] "fluxiceamm_icenit"          "fluxwcamm_iceamm"           "fluxwcamm_icealg"          
# [466] "fluxsnownit_wcnit"          "fluxsnownit_atmos"          "fluxicenit_wcnit"          
# [469] "fluxicenit_atmos"           "fluxwcnit_icenit"           "fluxwcnit_icealg"          
# [472] "fluxicedet_wcamm"           "fluxicedet_wcdet"           "fluxicedet_omni"           
# [475] "fluxwcdet_icedet"           "fluxicealg_icedet"          "fluxicealg_wcdet"          
# [478] "fluxicealg_omni"            "fluxicealg_phyt"            "fluxphyt_icealg"           
# [481] "fluxatmos_snowamm"          "fluxatmos_snownit"          "fluxatmos_wateramm"        
# [484] "fluxatmos_waternit"         "fluxbird_im_o"              "fluxseal_im_o"             
# [487] "fluxceta_im_o"              "fluxbear_im_o"              "fluxbird_im_i"             
# [490] "fluxseal_im_i"              "fluxceta_im_i"              "fluxbear_im_i"             
# [493] "fluxbird_em_o"              "fluxseal_em_o"              "fluxceta_em_o"             
# [496] "fluxbear_em_o"              "fluxbird_em_i"              "fluxseal_em_i"             
# [499] "fluxceta_em_i"              "fluxbear_em_i"              "totalN"                    
# [502] "totalN_o"                   "totalN_i"                   "x_detritus"                
# [505] "x_detritus_o"               "x_detritus_i"               "corpse"                    
# [508] "corpse_o"                   "corpse_i"                   "x_ammonia"                 
# [511] "x_ammonia_o"                "x_ammonia_i"                "x_nitrate"                 
# [514] "x_nitrate_o"                "x_nitrate_i"                "snow_ammonia"              
# [517] "snow_nitrate"               "ice_ammonia"                "ice_nitrate"               
# [520] "ice_detritus"               "s_detritus"                 "s_ammonia"                 
# [523] "s_nitrate"                  "ice_algae"                  "s_phyt"                    
# [526] "benthslar"                  "benthclar"                  "benths"                    
# [529] "benthc"                     "discard"                    "omni"                      
# [532] "carn"                       "fishp"                      "fishd"                     
# [535] "fishm"                      "bird"                       "seal"                      
# [538] "ceta"                       "bear"                       "fishplar"                  
# [541] "fishdlar"                   "PNP"                        "neticealgprod"             
# [544] "netpprod"                   "fluxwcamm_icealg.1"         "fluxwcnit_icealg.1"        
# [547] "fluxwcamm_phyt"             "fluxwcnit_phyt"             "icealggrossprod"           
# [550] "phytgrossprod"              "omnigrossprod"              "carngrossprod"             
# [553] "pfishlargrossprod"          "dfishlargrossprod"          "pfishgrossprod"            
# [556] "mfishgrossprod"             "dfishgrossprod"             "benthslargrossprod"        
# [559] "benthclargrossprod"         "benthsgrossprod"            "benthcgrossprod"           
# [562] "birdgrossprod"              "sealgrossprod"              "cetagrossprod"             
# [565] "beargrossprod"              "omninetprod"                "carnnetprod"               
# [568] "pfishlarnetprod"            "dfishlarnetprod"            "pfishnetprod"              
# [571] "mfishnetprod"               "dfishnetprod"               "benthslarnetprod"          
# [574] "benthclarnetprod"           "benthsnetprod"              "benthcnetprod"             
# [577] "birdnetprod"                "sealnetprod"                "cetanetprod"               
# [580] "bearnetprod"                "icesnowdenitrif"            "wcdenitrif"                
# [583] "seddenitrif"                "fluxsedboundary"            "DIN_NET_flux_o_i"          
# [586] "PART_NET_flux_o_i"          "NET_activemigpelfish_o_i"   "NET_activemigmigfish_o_i"  
# [589] "NET_activemigdemfish_o_i"   "NET_activemigbird_o_i"      "NET_activemigseal_o_i"     
# [592] "NET_activemigceta_o_i"      "NET_activemigbear_o_i"      "NET_mfish_ext_o"           
# [595] "fluxDINinflow"              "fluxDINoutflow"             "fluxPARTinflow"            
# [598] "fluxPARToutflow"            "atmosDINinput"              "rivDINinflow"              
# [601] "landp"                      "landd"                      "landd_o"                   
# [604] "landd_i"                    "landd_quota"                "landd_nonquota"            
# [607] "landm"                      "landsb"                     "landcb"                    
# [610] "landcz"                     "landbd"                     "landsl"                    
# [613] "landct"                     "discpel"                    "discdem"                   
# [616] "discdem_o"                  "discdem_i"                  "discdem_quota"             
# [619] "discdem_nonquota"           "discmig"                    "discsb"                    
# [622] "disccb"                     "disccz"                     "discbd"                    
# [625] "discsl"                     "discct"                     "offalpel"                  
# [628] "offaldem"                   "offaldem_o"                 "offaldem_i"                
# [631] "offaldem_quota"             "offaldem_nonquota"          "offalmig"                  
# [634] "offalsb"                    "offalcb"                    "offalcz"                   
# [637] "offalbd"                    "offalsl"                    "offalct"                   
# [640] "icealg_conc_m2ice_o"        "icealg_conc_m2ice_i"        "icedet_conc_m2ice_o"       
# [643] "icedet_conc_m2ice_i"        "icenit_conc_m3ice_o"        "icenit_conc_m3ice_i"       
# [646] "iceamm_conc_m3ice_o"        "iceamm_conc_m3ice_i"        "snownit_conc_m3snow_o"     
# [649] "snownit_conc_m3snow_i"      "snowamm_conc_m3snow_o"      "snowamm_conc_m3snow_i"     
# [652] "x_poros"                    "x_depth"                    "x_poros_o"                 
# [655] "x_poros_i"                  "x_depth_o"                  "x_depth_i"                 
# [658] "poricevol"                  "impicevol"                  "snowvol"                   
# [661] "shallowprop"                "depth_si"                   "depth_so"                  
# [664] "depth_d"                    "area_s0"                    "area_s1"                   
# [667] "area_s2"                    "area_s3"                    "area_d0"                   
# [670] "area_d1"                    "area_d2"                    "area_d3"                   
# [673] "depth_s1"                   "depth_s2"                   "depth_s3"                  
# [676] "depth_d1"                   "depth_d2"                   "depth_d3"                  
# [679] "poros_s1"                   "poros_s2"                   "poros_s3"                  
# [682] "poros_d1"                   "poros_d2"                   "poros_d3"                  
# [685] "poricevol_o"                "poricevol_i"                "impicevol_o"               
# [688] "impicevol_i"                "snowvol_o"                  "snowvol_i"                 
# [691] "iteration"                  "likelihood"                 "dummy"                     

#creds<-c(0.1,0.5,0.9)  # This can be any lenth of vector in anu order. All values must be between 0 and 1
creds<-c(0.005,0.25,0.5,0.75,0.995)



#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Build_Cred_Timeseries_Fluxes<-function(VtoPid,areaid,thikid,io,creds,varname){
#io = 0 means offshore
#io = 1 means inshore
#io = 2 means whole domain

rownamesvec<-rep(NA,(length(creds)+1))
for(kkk in 1:(length(creds)+1)){
if(kkk==1) rownamesvec[kkk]<-paste(varname,"-maxlik",sep="")
if(kkk>1)  rownamesvec[kkk]<-paste(varname,"-",creds[kkk-1],sep="")
}

Resultdata<-data.frame(rep(NA,(length(creds)+1)))
for(kkk in 1:360){
Resultdata[,kkk+1]<-(rep(NA,(length(creds)+1)))
}
names(Resultdata)<-seq(0,360)
row.names(Resultdata)<-rownamesvec

template<-data.frame(newlastyearstore$time)
names(template)<-"time"
if(io==2) template$VtoP<-newlastyearstore[,VtoPid]                                                           # per m2
if(io==1) template$VtoP<-newlastyearstore[,VtoPid]/(newlastyearstore[,areaid]*newlastyearstore[,thikid])     # per m3
if(io==0) template$VtoP<-newlastyearstore[,VtoPid]/((1-newlastyearstore[,areaid])*newlastyearstore[,thikid]) # per m3
template$iteration<-newlastyearstore$iteration
template$likelihood<-newlastyearstore$likelihood

for(ii in 0:360){
Resultdata[1,ii+1]<-template$VtoP[which(template$time==ii&template$iteration==1)]
modresvector<-template$VtoP[which(template$time==ii)]
likevector<-template$likelihood[which(template$time==ii)]
#message("\n","Processing ",varname," daily flux data                            ")
credvals<-GetCredInt(modresvector,likevector,creds,var=varname,plotgraph=FALSE)
Resultdata[2:(length(credvals)+1),ii+1]<-credvals
}

return(Resultdata)

}
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~




# CONVERT CUMULATIVE FLUX COLUMNS INTO DAILY FLUXES

#Find the number of runs that were stored


n_datasets<-nrow(lastyearstore)/361
newlastyearstore<-data.frame(lastyearstore$time)
names(newlastyearstore)<-"time"
newlastyearstore$dummy<-1
newlastyearstore$iteration<-lastyearstore$iteration
newlastyearstore$likelihood<-lastyearstore$likelihood
newlastyearstore$shallowprop<-lastyearstore$shallowprop
tempset<-rep(0,361)


################################################################


#[115] "cetagrossprod_i"            "wcdenitrif_o"               "wcdenitrif_i"              
#[118] "seddenitrif_o"              "seddenitrif_i"              "fluxsedamm_wcamm"          

col2proc<-142 # Offshore water column denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-143 # Inshore water colum denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}


col2proc<-450 # Offshore ice and snow denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-451 # Inshore ice and snow denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}


col2proc<-144 # Offshore sediment denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-145 # Inshore sediment denitrification
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

################################################################


#[295] "rivPARTinflow"              "DINflux_i_o"                "DINflux_o_i"               
#[298] "PARTflux_i_o"               "PARTflux_o_i"               "activemigpelfish_i_o"      
#[301] "activemigmigfish_i_o"       "activemigdemfish_i_o"       "activemigbird_i_o"         
#[304] "activemigseal_i_o"          "activemigceta_i_o"          "activemigpelfish_o_i"      
#[307] "activemigmigfish_o_i"       "activemigdemfish_o_i"       "activemigbird_o_i"         
#[310] "activemigseal_o_i"          "activemigceta_o_i"          "vertnitflux"               


col2proc<-329 # DINflux_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-330 # DINflux_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}


col2proc<-331 # PARTflux_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-332 # Partflux_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}




col2proc<-333 # activemigpelfish_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-340 # activemigpelfish_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#.........

col2proc<-334 # activemigmigfish_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-341 # activemigmigfish_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#.........

col2proc<-335 # activemigdemfish_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-342 # activemigdemfish_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#.........

col2proc<-336 # activemigbird_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-343 # activemigbird_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}


#.........

col2proc<-337 # activemigseal_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-344 # activemigseal_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#.........

col2proc<-338 # activemigceta_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-345 # activemigceta_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#.........

col2proc<-339 # activemigbear_i_o
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

col2proc<-346 # activemigbear_o_i
v2proc<-lastyearstore[,col2proc]
newcol<-(ncol(newlastyearstore)+1)
newnames<-c(names(newlastyearstore),names(lastyearstore)[col2proc])
newlastyearstore[,newcol]<-0
names(newlastyearstore)<-newnames
for(jjjj in 1:n_datasets){
tempset[1:360]<-v2proc[((jjjj-1)*361+1+(1)):(jjjj*361)]
tempset[361] <-v2proc[(jjjj*361)] + v2proc[((jjjj-1)*361+1+(1))] - v2proc[((jjjj-1)*361+1)]
newlastyearstore[((jjjj-1)*361+1):(jjjj*361),newcol] <- tempset - v2proc[((jjjj-1)*361+1):(jjjj*361)]
}

#...........................................

#Offhore water column denitrification
VtoPid<-which(names(newlastyearstore)=="wcdenitrif_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Offshore_water_column_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-Result_data

#Inshore water column denitrification
VtoPid<-which(names(newlastyearstore)=="wcdenitrif_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Inshore_water_column_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Offshore ice and snow denitrification
VtoPid<-which(names(newlastyearstore)=="icesnowdenitrif_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Offshore_ice_snow_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore ice and snow denitrification
VtoPid<-which(names(newlastyearstore)=="icesnowdenitrif_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Inshore_ice_snow_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)



#Offshore sediment denitrification
VtoPid<-which(names(newlastyearstore)=="seddenitrif_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Offshore_sediment_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Inshore sediment denitrification
VtoPid<-which(names(newlastyearstore)=="seddenitrif_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"Inshore_sediment_denitrification"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)



#......................


#DINflux_i to o
VtoPid<-which(names(newlastyearstore)=="DINflux_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"DINflux_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#DINflux_o to i
VtoPid<-which(names(newlastyearstore)=="DINflux_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"DINflux_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#PARTflux_i to o
VtoPid<-which(names(newlastyearstore)=="PARTflux_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"PARTflux_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#PARTflux_o to i
VtoPid<-which(names(newlastyearstore)=="PARTflux_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"PARTflux_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#......................

#Pelfish i to o
VtoPid<-which(names(newlastyearstore)=="activemigpelfish_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigpelfish_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Pelfish o to i
VtoPid<-which(names(newlastyearstore)=="activemigpelfish_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigpelfish_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Migfish i to o
VtoPid<-which(names(newlastyearstore)=="activemigmigfish_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigmigfish_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Migfish o to i
VtoPid<-which(names(newlastyearstore)=="activemigmigfish_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigmigfish_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Demfish i to o
VtoPid<-which(names(newlastyearstore)=="activemigdemfish_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigdemfish_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Demfish o to i
VtoPid<-which(names(newlastyearstore)=="activemigdemfish_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigdemfish_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Bird i to o
VtoPid<-which(names(newlastyearstore)=="activemigbird_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigbird_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Bird o to i
VtoPid<-which(names(newlastyearstore)=="activemigbird_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigbird_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Seal i to o
VtoPid<-which(names(newlastyearstore)=="activemigseal_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigseal_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Seal o to i
VtoPid<-which(names(newlastyearstore)=="activemigseal_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigseal_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#Ceta i to o
VtoPid<-which(names(newlastyearstore)=="activemigceta_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigceta_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Ceta o to i
VtoPid<-which(names(newlastyearstore)=="activemigceta_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigceta_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)



#Bear i to o
VtoPid<-which(names(newlastyearstore)=="activemigbear_i_o")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigbear_i_o"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)

#Bear o to i
VtoPid<-which(names(newlastyearstore)=="activemigbear_o_i")
areaid<-which(names(lastyearstore)=="dummy")
thikid<-which(names(lastyearstore)=="dummy")
io<-2  #whole domain
varname<-"activemigbear_o_i"
Result_data<-Build_Cred_Timeseries_Fluxes(VtoPid,areaid,thikid,io,creds,varname)
Result_data_store<-rbind(Result_data_store,Result_data)


#rowSums(Result_data_store)

csvfile <- csvname(credpath, "CredInt_processed_daily_fluxes", identifier)
writecsv(Result_data_store, csvfile)


Result_data_store


}

