#
# aggregate_model_output.R
#
#' 
#' create some aggregates of various columns in the output dataframe from the model
#'
#' @param model model object
#' @param output model output
#'
#' @return aggregated data
#'
#' @noRd
#
# ------------------------------------------------------------------------------

aggregate_model_output <- function(model, build, output) {

	# Unpack:
	data		<- elt(model, "data")
	forcings	<- elt(build, "forcings")

	physical.parms	<- elt(data, "physical.parameters")

	so_depth	<- elt(physical.parms, "so_depth")
	si_depth	<- elt(physical.parms, "si_depth")

	x_poros_s1	<- elt(physical.parms, "x_poros_s1")
	x_poros_s2	<- elt(physical.parms, "x_poros_s2")
	x_poros_s3	<- elt(physical.parms, "x_poros_s3")
	x_poros_d1	<- elt(physical.parms, "x_poros_d1")
	x_poros_d2	<- elt(physical.parms, "x_poros_d2")
	x_poros_d3	<- elt(physical.parms, "x_poros_d3")

	x_area_s1	<- elt(physical.parms, "x_area_s1")
	x_area_s2	<- elt(physical.parms, "x_area_s2")
	x_area_s3	<- elt(physical.parms, "x_area_s3")
	x_area_d1	<- elt(physical.parms, "x_area_d1")
	x_area_d2	<- elt(physical.parms, "x_area_d2")
	x_area_d3	<- elt(physical.parms, "x_area_d3")

	x_depth_s1	<- elt(physical.parms, "x_depth_s1")
	x_depth_s2	<- elt(physical.parms, "x_depth_s2")
	x_depth_s3	<- elt(physical.parms, "x_depth_s3")
	x_depth_d1	<- elt(physical.parms, "x_depth_d1")
	x_depth_d2	<- elt(physical.parms, "x_depth_d2")
	x_depth_d3	<- elt(physical.parms, "x_depth_d3")

	x_shallowprop	<- elt(physical.parms, "x_shallowprop")
	Porice_poros	<- elt(physical.parms, "Porice_poros")

	so_poricevol	<-(elt(forcings, "fdriverso_poricevol"))[,2]
	so_impicevol	<-(elt(forcings, "fdriverso_impicevol"))[,2]
	so_snowvol	<-(elt(forcings, "fdriverso_snowvol"))[,2]
	so_icecov	<-(elt(forcings, "fdriverso_icecov"))[,2]
	so_icefree	<-(elt(forcings, "fdriverso_icefree"))[,2]

	si_poricevol	<-(elt(forcings, "fdriversi_poricevol"))[,2]
	si_impicevol	<-(elt(forcings, "fdriversi_impicevol"))[,2]
	si_snowvol	<-(elt(forcings, "fdriversi_snowvol"))[,2]
	si_icecov	<-(elt(forcings, "fdriversi_icecov"))[,2]
	si_icefree	<-(elt(forcings, "fdriversi_icefree"))[,2]

	out		<- output

	aggregates	<- list()

	#Create a column for the total nitrogen mass in the system
	aggregates$totalN <-
		elt(out, "detritus_so")+
		elt(out, "detritus_d")+
		elt(out, "x_detritus_s1")+
		elt(out, "x_detritus_s2")+
		elt(out, "x_detritus_s3")+
		elt(out, "x_detritus_d1")+
		elt(out, "x_detritus_d2")+
		elt(out, "x_detritus_d3")+
		elt(out, "xR_detritus_s1")+
		elt(out, "xR_detritus_s2")+
		elt(out, "xR_detritus_s3")+
		elt(out, "xR_detritus_d1")+
		elt(out, "xR_detritus_d2")+
		elt(out, "xR_detritus_d3")+
		elt(out, "discard_o")+
		elt(out, "corpse_s0")+
		elt(out, "corpse_s1")+
		elt(out, "corpse_s2")+
		elt(out, "corpse_s3")+
		elt(out, "corpse_d0")+
		elt(out, "corpse_d1")+
		elt(out, "corpse_d2")+
		elt(out, "corpse_d3")+
		elt(out, "ammonia_so")+
		elt(out, "ammonia_d")+
		elt(out, "x_ammonia_s1")+
		elt(out, "x_ammonia_s2")+
		elt(out, "x_ammonia_s3")+
		elt(out, "x_ammonia_d1")+
		elt(out, "x_ammonia_d2")+
		elt(out, "x_ammonia_d3")+
		elt(out, "nitrate_so")+
		elt(out, "nitrate_d")+
		elt(out, "x_nitrate_s1")+
		elt(out, "x_nitrate_s2")+
		elt(out, "x_nitrate_s3")+
		elt(out, "x_nitrate_d1")+
		elt(out, "x_nitrate_d2")+
		elt(out, "x_nitrate_d3")+
		elt(out, "kelpN")+
		elt(out, "kelpdebris")+
		elt(out, "phyt_so")+
		elt(out, "phyt_d")+
		elt(out, "omni_o")+
		elt(out, "omni_i")+
		elt(out, "carn_o")+
		elt(out, "carn_i")+
		elt(out, "benthslar_o")+
		elt(out, "benthclar_o")+
		elt(out, "benths_o")+
		elt(out, "benthc_o")+
		elt(out, "fishplar_o")+
		elt(out, "fishplar_i")+
		elt(out, "fishp_o")+
		elt(out, "fishp_i")+
		elt(out, "fishdlar_o")+
		elt(out, "fishdlar_i")+
		elt(out, "fishd_o")+
		elt(out, "fishd_i")+
		elt(out, "fishm_o")+
		elt(out, "fishm_i")+
		elt(out, "bird_o")+
		elt(out, "bird_i")+
		elt(out, "seal_o")+
		elt(out, "seal_i")+
		elt(out, "ceta_o")+
		elt(out, "ceta_i")+

		elt(out, "bear_o")+
		elt(out, "bear_i")+

		elt(out, "detritus_si")+
		elt(out, "ammonia_si")+
		elt(out, "nitrate_si")+
		elt(out, "phyt_si")+
		elt(out, "benthslar_i")+
		elt(out, "benthclar_i")+
		elt(out, "benths_i")+
		elt(out, "benthc_i")+
		elt(out, "discard_i")+

		elt(out, "snow_ammonia_o")+
		elt(out, "snow_nitrate_o")+            
		elt(out, "ice_ammonia_o")+
		elt(out, "ice_nitrate_o")+           
		elt(out, "ice_detritus_o")+
		elt(out, "ice_algae_o")+

		elt(out, "snow_ammonia_i")+
		elt(out, "snow_nitrate_i")+          
		elt(out, "ice_ammonia_i")+
		elt(out, "ice_nitrate_i")+           
		elt(out, "ice_detritus_i")+
		elt(out, "ice_algae_i")


	aggregates$totalN_o <-
		elt(out, "detritus_so")+
		elt(out, "detritus_d")+
		elt(out, "x_detritus_d1")+
		elt(out, "x_detritus_d2")+
		elt(out, "x_detritus_d3")+
		elt(out, "xR_detritus_d1")+
		elt(out, "xR_detritus_d2")+
		elt(out, "xR_detritus_d3")+
		elt(out, "discard_o")+
		elt(out, "corpse_d0")+
		elt(out, "corpse_d1")+
		elt(out, "corpse_d2")+
		elt(out, "corpse_d3")+
		elt(out, "ammonia_so")+
		elt(out, "ammonia_d")+
		elt(out, "x_ammonia_d1")+
		elt(out, "x_ammonia_d2")+
		elt(out, "x_ammonia_d3")+
		elt(out, "nitrate_so")+
		elt(out, "nitrate_d")+
		elt(out, "x_nitrate_d1")+
		elt(out, "x_nitrate_d2")+
		elt(out, "x_nitrate_d3")+
		elt(out, "phyt_so")+
		elt(out, "phyt_d")+
		elt(out, "omni_o")+
		elt(out, "carn_o")+
		elt(out, "benthslar_o")+
		elt(out, "benthclar_o")+
		elt(out, "benths_o")+
		elt(out, "benthc_o")+
		elt(out, "fishplar_o")+
		elt(out, "fishp_o")+
		elt(out, "fishdlar_o")+
		elt(out, "fishd_o")+
		elt(out, "fishm_o")+
		elt(out, "bird_o")+
		elt(out, "seal_o")+
		elt(out, "ceta_o")+

		elt(out, "bear_o")+

		elt(out, "snow_ammonia_o")+
		elt(out, "snow_nitrate_o")+            
		elt(out, "ice_ammonia_o")+
		elt(out, "ice_nitrate_o")+           
		elt(out, "ice_detritus_o")+
		elt(out, "ice_algae_o")


	aggregates$totalN_i <-
		elt(out, "x_detritus_s1")+
		elt(out, "x_detritus_s2")+
		elt(out, "x_detritus_s3")+
		elt(out, "xR_detritus_s1")+
		elt(out, "xR_detritus_s2")+
		elt(out, "xR_detritus_s3")+
		elt(out, "corpse_s0")+
		elt(out, "corpse_s1")+
		elt(out, "corpse_s2")+
		elt(out, "corpse_s3")+
		elt(out, "x_ammonia_s1")+
		elt(out, "x_ammonia_s2")+
		elt(out, "x_ammonia_s3")+
		elt(out, "x_nitrate_s1")+
		elt(out, "x_nitrate_s2")+
		elt(out, "x_nitrate_s3")+
		elt(out, "omni_i")+
		elt(out, "carn_i")+
		elt(out, "fishplar_i")+
		elt(out, "fishp_i")+
		elt(out, "fishdlar_i")+
		elt(out, "fishd_i")+
		elt(out, "fishm_i")+
		elt(out, "bird_i")+
		elt(out, "seal_i")+
		elt(out, "ceta_i")+

		elt(out, "bear_i")+

		elt(out, "detritus_si")+
		elt(out, "ammonia_si")+
		elt(out, "nitrate_si")+
		elt(out, "kelpN")+
		elt(out, "kelpdebris")+
		elt(out, "phyt_si")+
		elt(out, "benthslar_i")+
		elt(out, "benthclar_i")+
		elt(out, "benths_i")+
		elt(out, "benthc_i")+
		elt(out, "discard_i")+

		elt(out, "snow_ammonia_i")+
		elt(out, "snow_nitrate_i")+          
		elt(out, "ice_ammonia_i")+
		elt(out, "ice_nitrate_i")+           
		elt(out, "ice_detritus_i")+
		elt(out, "ice_algae_i")

	#Create columns to aggregate across sediment categories

	aggregates$x_detritus <-
		elt(out, "x_detritus_s1")+
		elt(out, "x_detritus_s2")+
		elt(out, "x_detritus_s3")+
		elt(out, "x_detritus_d1")+
		elt(out, "x_detritus_d2")+
		elt(out, "x_detritus_d3")+
		elt(out, "xR_detritus_s1")+
		elt(out, "xR_detritus_s2")+
		elt(out, "xR_detritus_s3")+
		elt(out, "xR_detritus_d1")+
		elt(out, "xR_detritus_d2")+
		elt(out, "xR_detritus_d3")

	aggregates$x_detritus_o<-elt(out, "x_detritus_d1")+ elt(out, "x_detritus_d2")+ elt(out, "x_detritus_d3")+
		elt(out, "xR_detritus_d1")+ elt(out, "xR_detritus_d2")+ elt(out, "xR_detritus_d3")

	aggregates$x_detritus_i<-elt(out, "x_detritus_s1")+ elt(out, "x_detritus_s2")+ elt(out, "x_detritus_s3")+
		elt(out, "xR_detritus_s1")+ elt(out, "xR_detritus_s2")+ elt(out, "xR_detritus_s3")


	aggregates$corpse<-elt(out, "corpse_s0")+elt(out, "corpse_s1")+ elt(out, "corpse_s2")+ elt(out, "corpse_s3")+elt(out, "corpse_d0")+ elt(out, "corpse_d1")+ elt(out, "corpse_d2")+ elt(out, "corpse_d3")
	aggregates$corpse_o<-elt(out, "corpse_d0")+elt(out, "corpse_d1")+ elt(out, "corpse_d2")+ elt(out, "corpse_d3")
	aggregates$corpse_i<-elt(out, "corpse_s0")+elt(out, "corpse_s1")+ elt(out, "corpse_s2")+ elt(out, "corpse_s3")

	aggregates$x_ammonia<-elt(out, "x_ammonia_s1")+ elt(out, "x_ammonia_s2")+ elt(out, "x_ammonia_s3")+ elt(out, "x_ammonia_d1")+ elt(out, "x_ammonia_d2")+ elt(out, "x_ammonia_d3")
	aggregates$x_ammonia_o<-elt(out, "x_ammonia_d1")+ elt(out, "x_ammonia_d2")+ elt(out, "x_ammonia_d3")
	aggregates$x_ammonia_i<-elt(out, "x_ammonia_s1")+ elt(out, "x_ammonia_s2")+ elt(out, "x_ammonia_s3")

	aggregates$x_nitrate<-elt(out, "x_nitrate_s1")+ elt(out, "x_nitrate_s2")+ elt(out, "x_nitrate_s3")+ elt(out, "x_nitrate_d1")+ elt(out, "x_nitrate_d2")+ elt(out, "x_nitrate_d3")
	aggregates$x_nitrate_o<-elt(out, "x_nitrate_d1")+ elt(out, "x_nitrate_d2")+ elt(out, "x_nitrate_d3")
	aggregates$x_nitrate_i<-elt(out, "x_nitrate_s1")+ elt(out, "x_nitrate_s2")+ elt(out, "x_nitrate_s3")

	#Create state variable aggregates across inshore and offshore

	aggregates$snow_ammonia<-elt(out, "snow_ammonia_o")+elt(out, "snow_ammonia_i")
	aggregates$snow_nitrate<-elt(out, "snow_nitrate_o")+elt(out, "snow_nitrate_i")

	aggregates$ice_ammonia<-elt(out, "ice_ammonia_o")+elt(out, "ice_ammonia_i")
	aggregates$ice_nitrate<-elt(out, "ice_nitrate_o")+elt(out, "ice_nitrate_i")
	aggregates$ice_detritus<-elt(out, "ice_detritus_o")+elt(out, "ice_detritus_i")

	aggregates$s_detritus<-elt(out, "detritus_so")+elt(out, "detritus_si")
	aggregates$s_ammonia<-elt(out, "ammonia_so")+elt(out, "ammonia_si")
	aggregates$s_nitrate<-elt(out, "nitrate_so")+elt(out, "nitrate_si")

	aggregates$ice_algae<-elt(out, "ice_algae_o")+elt(out, "ice_algae_i")

	aggregates$s_phyt<-elt(out, "phyt_so")+elt(out, "phyt_si")
	aggregates$benthslar<-elt(out, "benthslar_o")+elt(out, "benthslar_i")
	aggregates$benthclar<-elt(out, "benthclar_o")+elt(out, "benthclar_i")
	aggregates$benths<-elt(out, "benths_o")+elt(out, "benths_i")
	aggregates$benthc<-elt(out, "benthc_o")+elt(out, "benthc_i")
	aggregates$discard<-elt(out, "discard_o")+elt(out, "discard_i")

	aggregates$omni<-elt(out, "omni_o")+elt(out, "omni_i")

	aggregates$carn<-elt(out, "carn_o")+elt(out, "carn_i")

	aggregates$fishp<-elt(out, "fishp_o")+elt(out, "fishp_i")
	aggregates$fishd<-elt(out, "fishd_o")+elt(out, "fishd_i")
	aggregates$fishm<-elt(out, "fishm_o")+elt(out, "fishm_i")
	aggregates$bird<-elt(out, "bird_o")+elt(out, "bird_i")

	aggregates$seal<-elt(out, "seal_o")+elt(out, "seal_i")
	aggregates$ceta<-elt(out, "ceta_o")+elt(out, "ceta_i")

	aggregates$bear<-elt(out, "bear_o")+elt(out, "bear_i")

	aggregates$fishplar<-elt(out, "fishplar_o")+elt(out, "fishplar_i")
	aggregates$fishdlar<-elt(out, "fishdlar_o")+elt(out, "fishdlar_i")

	aggregates$snow_ammonia<-elt(out, "snow_ammonia_o")+elt(out, "snow_ammonia_i")
	aggregates$snow_nitrate<-elt(out, "snow_nitrate_o")+elt(out, "snow_nitrate_i")

	aggregates$ice_ammonia<-elt(out, "ice_ammonia_o")+elt(out, "ice_ammonia_i")
	aggregates$ice_nitrate<-elt(out, "ice_nitrate_o")+elt(out, "ice_nitrate_i")
	
	aggregates$ice_detritus<-elt(out, "ice_detritus_o")+elt(out, "ice_detritus_i")
	aggregates$ice_algae<-elt(out, "ice_algae_o")+elt(out, "ice_algae_i")


	#Create aggregates for flux terms which are ouput as separate for o and i

	aggregates$PNP			<- elt(out, "PNP_o")+ elt(out, "PNP_i")

	aggregates$neticealgprod <- out$neticealgprod_o + out$neticealgprod_i   ###########################

	aggregates$netpprod <- out$netpprod_o + out$netpprod_i

	aggregates$fluxwcamm_icealg <- out$fluxwcamm_icealg_o  +  out$fluxwcamm_phyt_i  ####################

	aggregates$fluxwcnit_icealg <- out$fluxwcnit_icealg_o  +  out$fluxwcnit_icealg_i  ########################

	aggregates$fluxwcamm_phyt <- out$fluxwcamm_phyt_o  +  out$fluxwcamm_phyt_i

	aggregates$fluxwcnit_phyt <- out$fluxwcnit_phyt_o  +  out$fluxwcnit_phyt_i

        aggregates$icealggrossprod <- out$icealggrossprod_o + out$icealggrossprod_i    #####################

	aggregates$phytgrossprod <- out$phytgrossprod_o + out$phytgrossprod_i

	aggregates$omnigrossprod <- out$omnigrossprod_o + out$omnigrossprod_i
	aggregates$carngrossprod <- out$carngrossprod_o + out$carngrossprod_i
	aggregates$pfishlargrossprod <- out$pfishlargrossprod_o + out$pfishlargrossprod_i
	aggregates$dfishlargrossprod <- out$dfishlargrossprod_o + out$dfishlargrossprod_i
	aggregates$pfishgrossprod <- out$pfishgrossprod_o + out$pfishgrossprod_i
	aggregates$mfishgrossprod <- out$mfishgrossprod_o + out$mfishgrossprod_i
	aggregates$dfishgrossprod <- out$dfishgrossprod_o + out$dfishgrossprod_i
	aggregates$benthslargrossprod <- out$benthslargrossprod_o + out$benthslargrossprod_i
	aggregates$benthclargrossprod <- out$benthclargrossprod_o + out$benthclargrossprod_i
	aggregates$benthsgrossprod <- out$benthsgrossprod_o + out$benthsgrossprod_i
	aggregates$benthcgrossprod <- out$benthcgrossprod_o + out$benthcgrossprod_i
	aggregates$birdgrossprod <- out$birdgrossprod_o + out$birdgrossprod_i
	aggregates$sealgrossprod <- out$sealgrossprod_o + out$sealgrossprod_i
	aggregates$cetagrossprod <- out$cetagrossprod_o + out$cetagrossprod_i
	aggregates$beargrossprod <- out$beargrossprod_o + out$beargrossprod_i   #####################

	aggregates$omninetprod <- out$omninetprod_o + out$omninetprod_i
	aggregates$carnnetprod <- out$carnnetprod_o + out$carnnetprod_i
	aggregates$pfishlarnetprod <- out$pfishlarnetprod_o + out$pfishlarnetprod_i
	aggregates$dfishlarnetprod <- out$dfishlarnetprod_o + out$dfishlarnetprod_i
	aggregates$pfishnetprod <- out$pfishnetprod_o + out$pfishnetprod_i
	aggregates$mfishnetprod <- out$mfishnetprod_o + out$mfishnetprod_i
	aggregates$dfishnetprod <- out$dfishnetprod_o + out$dfishnetprod_i
	aggregates$benthslarnetprod <- out$benthslarnetprod_o + out$benthslarnetprod_i
	aggregates$benthclarnetprod <- out$benthclarnetprod_o + out$benthclarnetprod_i
	aggregates$benthsnetprod <- out$benthsnetprod_o + out$benthsnetprod_i
	aggregates$benthcnetprod <- out$benthcnetprod_o + out$benthcnetprod_i
	aggregates$birdnetprod <- out$birdnetprod_o + out$birdnetprod_i
	aggregates$sealnetprod <- out$sealnetprod_o + out$sealnetprod_i
	aggregates$cetanetprod <- out$cetanetprod_o + out$cetanetprod_i
	aggregates$bearnetprod <- out$bearnetprod_o + out$bearnetprod_i    ##########################


	aggregates$icesnowdenitrif <- elt(out, "icesnowdenitrif_o")+ elt(out, "icesnowdenitrif_i")   ##########################


	aggregates$wcdenitrif		<- elt(out, "wcdenitrif_o")+ elt(out, "wcdenitrif_i")
	aggregates$seddenitrif		<- elt(out, "seddenitrif_o")+ elt(out, "seddenitrif_i")
	aggregates$fluxsedboundary	<- elt(out, "fluxsedboundary_o")+ elt(out, "fluxsedboundary_i")
	aggregates$DIN_NET_flux_o_i	<- elt(out, "DINflux_o_i") - elt(out, "DINflux_i_o")
	aggregates$PART_NET_flux_o_i	<- elt(out, "PARTflux_o_i") - elt(out, "PARTflux_i_o")

	aggregates$NET_activemigpelfish_o_i  <- out$activemigpelfish_o_i - out$activemigpelfish_i_o
	aggregates$NET_activemigmigfish_o_i  <- out$activemigmigfish_o_i - out$activemigmigfish_i_o
	aggregates$NET_activemigdemfish_o_i  <- out$activemigdemfish_o_i - out$activemigdemfish_i_o
	aggregates$NET_activemigbird_o_i  <- out$activemigbird_o_i - out$activemigbird_i_o
	aggregates$NET_activemigseal_o_i  <- out$activemigseal_o_i - out$activemigseal_i_o
	aggregates$NET_activemigceta_o_i  <- out$activemigceta_o_i - out$activemigceta_i_o
	aggregates$NET_activemigbear_o_i  <- out$activemigbear_o_i - out$activemigbear_i_o    #####################
	aggregates$NET_mfish_ext_o    <- out$mfish_imigration - out$mfish_emigration

	aggregates$fluxDINinflow   <- out$fluxAMMinflow_o  + out$fluxAMMinflow_i + out$fluxNITinflow_o  + out$fluxNITinflow_i
	aggregates$fluxDINoutflow  <- out$fluxAMMoutflow_o + out$fluxAMMoutflow_i + out$fluxNIToutflow_o + out$fluxNIToutflow_i
	aggregates$fluxPARTinflow  <- out$fluxPHYTinflow_o + out$fluxPHYTinflow_i + out$fluxDETinflow_o + out$fluxDETinflow_i
	aggregates$fluxPARToutflow <- out$fluxPHYToutflow_o+ out$fluxPHYToutflow_i + out$fluxDEToutflow_o+ out$fluxDEToutflow_i
	aggregates$atmosDINinput   <- out$atmosAMMinput_o  + out$atmosAMMinput_i + out$atmosNITinput_o  + out$atmosNITinput_i
	aggregates$rivDINinflow   <- out$rivAMMinflow  + out$rivNITinflow


	#Create columns for whole domain live landed weights 

	aggregates$landp<-elt(out, "landp_o")+elt(out, "landp_i")

	aggregates$landd<-elt(out, "landd_quota_o")+elt(out, "landd_nonquota_o")+elt(out, "landd_quota_i")+elt(out, "landd_nonquota_i")
	aggregates$landd_o<-elt(out, "landd_quota_o")+elt(out, "landd_nonquota_o")
	aggregates$landd_i<-elt(out, "landd_quota_i")+elt(out, "landd_nonquota_i")

	aggregates$landd_quota<-elt(out, "landd_quota_o")+elt(out, "landd_quota_i")
	aggregates$landd_nonquota<-elt(out, "landd_nonquota_o")+elt(out, "landd_nonquota_i")

	aggregates$landm<-elt(out, "landm_o")+elt(out, "landm_i")

	aggregates$landsb<-elt(out, "landsb_o")+elt(out, "landsb_i")

	aggregates$landcb<-elt(out, "landcb_o")+elt(out, "landcb_i")

	aggregates$landcz<-elt(out, "landcz_o")+elt(out, "landcz_i")

	aggregates$landbd<-out$landbd_o+out$landbd_i

	aggregates$landsl<-out$landsl_o+out$landsl_i

	aggregates$landct<-out$landct_o+out$landct_i

	#Create columns for whole domian discards 

	aggregates$discpel<-out$discpel_o+out$discpel_i

	aggregates$discdem<-out$discdem_quota_o+out$discdem_nonquota_o+out$discdem_quota_i+out$discdem_nonquota_i
	aggregates$discdem_o<-out$discdem_quota_o+out$discdem_nonquota_o
	aggregates$discdem_i<-out$discdem_quota_i+out$discdem_nonquota_i

	aggregates$discdem_quota<-out$discdem_quota_o+out$discdem_quota_i
	aggregates$discdem_nonquota<-out$discdem_nonquota_o+out$discdem_nonquota_i

	aggregates$discmig<-out$discmig_o+out$discmig_i

	aggregates$discsb<-out$discsb_o+out$discsb_i

	aggregates$disccb<-out$disccb_o+out$disccb_i

	aggregates$disccz<-out$disccz_o+out$disccz_i

	aggregates$discbd<-out$discbd_o+out$discbd_i

	aggregates$discsl<-out$discsl_o+out$discsl_i
	aggregates$discct<-out$discct_o+out$discct_i


	#Create columns for whole domain offal production

	aggregates$offalpel<-out$offalpel_o+out$offalpel_i

	aggregates$offaldem<-out$offaldem_quota_o+out$offaldem_nonquota_o+out$offaldem_quota_i+out$offaldem_nonquota_i
	aggregates$offaldem_o<-out$offaldem_quota_o+out$offaldem_nonquota_o
	aggregates$offaldem_i<-out$offaldem_quota_i+out$offaldem_nonquota_i

	aggregates$offaldem_quota<-out$offaldem_quota_o+out$offaldem_quota_i
	aggregates$offaldem_nonquota<-out$offaldem_nonquota_o+out$offaldem_nonquota_i

	aggregates$offalmig<-out$offalmig_o+out$offalmig_i

	aggregates$offalsb<-out$offalsb_o+out$offalsb_i

	aggregates$offalcb<-out$offalcb_o+out$offalcb_i

	aggregates$offalcz<-out$offalcz_o+out$offalcz_i

	aggregates$offalbd<-out$offalbd_o+out$offalbd_i

	aggregates$offalsl<-out$offalsl_o+out$offalsl_i
	aggregates$offalct<-out$offalct_o+out$offalct_i

        #  Compute some in-ice concentrations that can't be done later on average data cos ice is changing over time too
	# Ice algae concentration /m2 of ice
	aggregates$icealg_conc_m2ice_o <- NA
        posv<-which( ((1-so_icefree) * so_icecov)>0)
	aggregates$icealg_conc_m2ice_o[posv] <- (elt(out, "ice_algae_o"))[posv] / ( (1-x_shallowprop) * (1-so_icefree[posv]) * so_icecov[posv] )

	aggregates$icealg_conc_m2ice_i <- NA
        posv<-which( ((1-si_icefree) * si_icecov)>0)
	aggregates$icealg_conc_m2ice_i[posv] <- (elt(out, "ice_algae_i"))[posv] / ( (x_shallowprop) * (1-si_icefree[posv]) * si_icecov[posv] )

	#.............................

	# Ice detritus concentration /m2 of ice
	aggregates$icedet_conc_m2ice_o <- NA
        posv<-which( ((1-so_icefree) * so_icecov)>0)
	aggregates$icedet_conc_m2ice_o[posv] <- (elt(out, "ice_detritus_o"))[posv] / ( (1-x_shallowprop) * (1-so_icefree[posv]) * so_icecov[posv] )

	aggregates$icedet_conc_m2ice_i <- NA
        posv<-which( ((1-si_icefree) * si_icecov)>0)
	aggregates$icedet_conc_m2ice_i[posv] <- (elt(out, "ice_detritus_i"))[posv] / ( (x_shallowprop) * (1-si_icefree[posv]) * si_icecov[posv] )

	#.............................

	# Offshore Ice-associated nitrate = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceassociated_nit_o <- NA
	posv<-which(so_poricevol > 0)
	aggregates$iceassociated_nit_o[posv] <- (  ((elt(out, "ice_nitrate_o"))[posv])  +  ((((elt(out, "nitrate_so"))[posv])/(so_depth * (1-x_shallowprop)))*(so_poricevol[posv] * Porice_poros)) )

	#  OffshoreIce nitrate /m3 ice = combination of impervious ice nutrient + porous ice nutrient
	aggregates$icenit_conc_m3ice_o <- NA
	aggregates$icenit_conc_m3ice_o[posv] <- aggregates$iceassociated_nit_o[posv] / (so_poricevol[posv] + so_impicevol[posv]) 

	# Inshore Ice-associated nitrate = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceassociated_nit_i <- NA
	posv<-which(si_poricevol > 0)
	aggregates$iceassociated_nit_i[posv] <- (  ((elt(out, "ice_nitrate_i"))[posv])  +  ((((elt(out, "nitrate_si"))[posv])/(si_depth * (x_shallowprop)))*(si_poricevol[posv] * Porice_poros)) )

	# Inshore Ice nitrate /m3 ice = combination of impervious ice nutrient + porous ice nutrient
	aggregates$icenit_conc_m3ice_i <- NA
	aggregates$icenit_conc_m3ice_i[posv] <- aggregates$iceassociated_nit_i[posv] / (si_poricevol[posv] + si_impicevol[posv]) 

	#.............................

	# Offshore Ice-associated ammonia = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceassociated_amm_o <- NA
	posv<-which(so_poricevol > 0)
	aggregates$iceassociated_amm_o[posv] <- (  ((elt(out, "ice_ammonia_o"))[posv])  +  ((((elt(out, "ammonia_so"))[posv])/(so_depth * (1-x_shallowprop)))*(so_poricevol[posv] * Porice_poros)) )

	#  OffshoreIce ammonia /m3 ice = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceamm_conc_m3ice_o <- NA
	aggregates$iceamm_conc_m3ice_o[posv] <- aggregates$iceassociated_amm_o[posv] / (so_poricevol[posv] + so_impicevol[posv]) 

	# Inshore Ice-associated ammonia = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceassociated_amm_i <- NA
	posv<-which(si_poricevol > 0)
	aggregates$iceassociated_amm_i[posv] <- (  ((elt(out, "ice_ammonia_i"))[posv])  +  ((((elt(out, "ammonia_si"))[posv])/(si_depth * (x_shallowprop)))*(si_poricevol[posv] * Porice_poros)) )

	# Inshore Ice ammonia /m3 ice = combination of impervious ice nutrient + porous ice nutrient
	aggregates$iceamm_conc_m3ice_i <- NA
	aggregates$iceamm_conc_m3ice_i[posv] <- aggregates$iceassociated_nit_i[posv] / (si_poricevol[posv] + si_impicevol[posv]) 

	#.............................

	# Snow nitrate /m3 snow
	aggregates$snownit_conc_m3snow_o <- NA
	posv<-which(so_snowvol > 0)
	aggregates$snownit_conc_m3snow_o[posv] <- ((elt(out, "snow_nitrate_o"))[posv]) / (so_snowvol[posv])

	aggregates$snownit_conc_m3snow_i <- NA
	posv<-which(si_snowvol > 0)
	aggregates$snownit_conc_m3snow_i[posv] <- ((elt(out, "snow_nitrate_i"))[posv]) / (si_snowvol[posv])

	#.............................

	# Snow ammonia /m3 snow
	aggregates$snowamm_conc_m3snow_o <- NA
	posv<-which(so_snowvol > 0)
	aggregates$snowamm_conc_m3snow_o[posv] <- ((elt(out, "snow_ammonia_o"))[posv]) / (so_snowvol[posv])

	aggregates$snowamm_conc_m3snow_i <- NA
	posv<-which(si_snowvol > 0)
	aggregates$snowamm_conc_m3snow_i[posv] <- ((elt(out, "snow_ammonia_i"))[posv]) / (si_snowvol[posv])



	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	aggregates$x_poros<- ((x_poros_s1*x_area_s1) +
		(x_poros_s2*x_area_s2) +
		(x_poros_s3*x_area_s3) +
		(x_poros_d1*x_area_d1) +
		(x_poros_d2*x_area_d2) +
		(x_poros_d3*x_area_d3))

	aggregates$x_depth<- ((x_depth_s1*x_area_s1) +
		(x_depth_s2*x_area_s2) +
		(x_depth_s3*x_area_s3) +
		(x_depth_d1*x_area_d1) +
		(x_depth_d2*x_area_d2) +
		(x_depth_d3*x_area_d3))


	aggregates$x_poros_o<-((x_poros_d1*x_area_d1) +
		(x_poros_d2*x_area_d2) +
		(x_poros_d3*x_area_d3))/(x_area_d1+x_area_d2+x_area_d3)

	aggregates$x_poros_i<- ((x_poros_s1*x_area_s1) +
		(x_poros_s2*x_area_s2) +
		(x_poros_s3*x_area_s3))/(x_area_s1+x_area_s2+x_area_s3)

	aggregates$x_depth_o<- ((x_depth_d1*x_area_d1) +
		(x_depth_d2*x_area_d2) +
		(x_depth_d3*x_area_d3))/(x_area_d1+x_area_d2+x_area_d3)

	aggregates$x_depth_i<- ((x_depth_s1*x_area_s1) +
		(x_depth_s2*x_area_s2) +
		(x_depth_s3*x_area_s3))/(x_area_s1+x_area_s2+x_area_s3)

	aggregates$poricevol<-	so_poricevol+si_poricevol
	aggregates$impicevol<-	so_impicevol+si_impicevol
	aggregates$snowvol<-	so_snowvol+si_snowvol


	aggregates
}

