% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2ep_plot_catch.R
\name{e2ep_plot_catch}
\alias{e2ep_plot_catch}
\title{Plot the distribution and composition of annual catches across guild, zones and gears in the final year of a model run.}
\usage{
e2ep_plot_catch(model, results, selection = "BY_GEAR")
}
\arguments{
\item{model}{R-list object defining the baseline model configuration used to generate the data and compiled by the e2ep_read() function.}

\item{results}{List object of single-run model output generated by running the function e2ep_run() function.}

\item{selection}{Text string from a list identifying the group of model output variables to be plotted. Select from: "BY_GUILD", "BY_GEAR". With the former, each panel represents a different guild; with the latter, each panel represnts a different gear. Remember to include the phrase within "" quotes.}
}
\value{
graphical display in a new graphics window.
}
\description{
Create stacked barplots of the distribution of offshore and inshore landings and discards across gears by guild, or across guilds by gears, in the final year of a model run.
}
\details{
Data in zonal landings and discards by guild and gear in the final year of a model run are generated as a standard output from the model, and saved both as csv files and in the results object returned by the e2ep_run() function.
This function organises these data in two different ways to display as barplots.

The first display is a multi-panel plot in which each panel represents a different guild, and the bars show the zonal landings by each gear. The alternative display
has each panel as a different gear, and the bars show the landings and discards of each guild.

The unit of the displayed data are mMN/y from the model domain as a whole, which is taken as being 1m2.
}
\examples{
# Load the 2011-2019 version of the Barents Sea model supplied with the package, run, and
# generate a plot:
    model <- e2ep_read("Barents_Sea", "2011-2019")
    results <- e2ep_run(model, nyears=2,csv.output=FALSE)
    e2ep_plot_catch(model, results, selection="BY_GEAR")
    dev.new()
    e2ep_plot_catch(model, results, selection="BY_GUILD")

}
\seealso{
\code{\link{e2ep_read}}, \code{\link{e2ep_run}}, \code{\link{e2ep_plot_migration}}, \code{\link{e2ep_plot_eco}}, \code{\link{e2ep_plot_trophic}}, \code{\link{e2ep_plot_biomass}}
}
